<?php
/**
* Author: DragonFever
* Copyright: © 2008 DragonFever
* Website:  http://www.dragonfever.info
**/

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("usercp_start", "lastxonucp_run");

function lastxonucp_info()
{
	return array(
		"name"			=> "هاك اخر المواضيع والمشاركات والمواضيع الهامه بلوحة التحكم للعضو",
		"description"	=> "يقوم بعرض اخر مشاركات ومواضيع والمواضيع الهامه للعضو في لوحة تحكمه.",
		"website"		=> "http://www.dragonfever.info",
		"author"		=> "DragonFever",
		"authorsite"	=> "http://www.dragonfever.info",
		"version"		=> "1.0",
		"guid"			=> "39cd48205abf75745f33f13c24214bd4",
		"compatibility" => "16*",
	);
}

function lastxonucp_install()
{
	global $db;
	
	$query = $db->simple_select("settinggroups", "COUNT(*) as rows");
	$rows = $db->fetch_field($query, "rows");
	
	$insertarray = array(
		'name' => 'lastxonucp', 
		'title' => 'هاك اخر المواضيع والمشاركات والمواضيع الهامه بلوحة التحكم للعضو', 
		'description' => 'اعدادات الهاك', 
		'disporder' => $rows+1, 
		'isdefault' => 0
	);
	$db->insert_query("settinggroups", $insertarray);
	$group['gid'] = $db->insert_id();
	
	$insertarray = array(
		'name' => 'lastxonucp_showlastthreads',
		'title' => 'تفعيل اخر المواضيع',
		'description' => '',
		'optionscode' => 'onoff',
		'value' => 1,
		'disporder' => 0,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_threadnum',
		'title' => 'عدد المواضيع التي تظهر',
		'description' => 'ادخل عدد المواضيع التي تريد ان يظهر في مربع اخر المواضيع',
		'optionscode' => 'text',
		'value' => '5',
		'disporder' => 1,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_showlastposts',
		'title' => 'تفعيل اخر المشاركات',
		'description' => '',
		'optionscode' => 'onoff',
		'value' => 1,
		'disporder' => 2,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_postnum',
		'title' => 'عدد المشاركات التي تظهر',
		'description' => 'ادخل عدد المشاركات التي تريد ان يظهر في مربع اخر المشاركات',
		'optionscode' => 'text',
		'value' => '5',
		'disporder' => 3,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_showpopular',
		'title' => 'عرض المواضيع الشعبيه',
		'description' => '',
		'optionscode' => 'onoff',
		'value' => 1,
		'disporder' => 4,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_popnum',
		'title' => 'كم عدد المواضيع الشعبيه',
		'description' => 'ادخل عدد المواضيع الشعبيه التي تريد ان تظهر في مربع اخر المواضيع الشعبيه',
		'optionscode' => 'text',
		'value' => '5',
		'disporder' => 5,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_poporder',
		'title' => 'ترتيب المواضيع الشعبيه',
		'description' => 'اختار طريقة ترتيب المواضيع الشعبيه.',
		'optionscode' => 'select
		0=مشاهدات
		1=ردود',
		'value' => '0',
		'disporder' => 6,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_threadcut',
		'title' => 'عدد حروف الموضوع لاخر المواضيع',
		'description' => 'اكتب عدد الحروف التي تريد يظهر في عنوان الموضوع لمربع اخر المواضيع.',
		'optionscode' => 'text',
		'value' => '30',
		'disporder' => 7,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);
	
	$insertarray = array(
		'name' => 'lastxonucp_forumcut',
		'title' => 'عدد حروف اسم القسم',
		'description' => 'اكتب عدد الحروف التي تريد ان يظهر في اسم القسم.',
		'optionscode' => 'text',
		'value' => '30',
		'disporder' => 8,
		'gid' => $group['gid']
	);
	$db->insert_query("settings", $insertarray);

	rebuild_settings();
}

function lastxonucp_is_installed()
{
	global $db;
	
	$query = $db->query("SELECT COUNT(*) AS num FROM ".TABLE_PREFIX."settinggroups WHERE name='lastxonucp'");
	$num = $db->fetch_array($query);
	
	if($num['num'] > "0")
	{
		return true;
	}
	
	return false;
}

function lastxonucp_activate()
{
	global $db, $mybb;
	
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("usercp", '#{\$latest_warnings}(\r?)\n#', "{\$latest_warnings}\n{\$my_last_threads}\n{\$my_last_posts}\n{\$my_popular_threads}\n");
	
	$insert_array = array(
		'title' => "usercp_mylastposts",
		'template' => "<br />
	<table border=\"0\" cellspacing=\"{\$theme[\'borderwidth\']}\" cellpadding=\"{\$theme[\'tablespace\']}\" class=\"tborder\">
		<thead>
			<tr>
				<td class=\"thead\" colspan=\"6\">
					<div><strong>{\$lang->lastxonucp_mylastposts}</strong></div>
				</td>
			</tr>
			<tr>
				<td class=\"tcat\" width=\"5%\">&nbsp;</td>
				<td class=\"tcat\" width=\"40%\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_thread}</strong></span></td>
				<td class=\"tcat\" width=\"20%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_forum}</strong></span></td>
				<td class=\"tcat\" width=\"10%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_replies}</strong></span></td>
				<td class=\"tcat\" width=\"10%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_views}</strong></span></td>
				<td class=\"tcat\" width=\"15%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_threadstarter}</strong></span></td>
			</tr>
		</thead>
		<tbody>
		{\$mylastposts}
		</tbody>
		<thead>
			<tr>
                               <td class=\"tfoot\" colspan=\"6\">
					<div class=\"float_right\">{\$findmyposts}</div>
					<div>{\$lang->lastxonucp_mytotalposts}: {\$mytotalposts}</div>
				</td>
			</tr>
		</thead>
	</table>",
		'sid' => "-1",
		'version' => "",
		'dateline' => TIME_NOW
	);
	
	$db->insert_query("templates", $insert_array);
	
	$insert_array = array(
		'title' => "usercp_mylastthreads",
		'template' => "<br />
	<table border=\"0\" cellspacing=\"{\$theme[\'borderwidth\']}\" cellpadding=\"{\$theme[\'tablespace\']}\" class=\"tborder\">
		<thead>
			<tr>
				<td class=\"thead\" colspan=\"6\">
					<div><strong>{\$lang->lastxonucp_mylastthreads}</strong></div>
				</td>
			</tr>
			<tr>
				<td class=\"tcat\" width=\"5%\">&nbsp;</td>
				<td class=\"tcat\" width=\"40%\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_thread}</strong></span></td>
				<td class=\"tcat\" width=\"20%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_forum}</strong></span></td>
				<td class=\"tcat\" width=\"10%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_replies}</strong></span></td>
				<td class=\"tcat\" width=\"10%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_views}</strong></span></td>
				<td class=\"tcat\" width=\"15%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_lastposter}</strong></span></td>
			</tr>
		</thead>
		<tbody>
		{\$mylastthreads}
		</tbody>
		<thead>
			<tr>
                               <td class=\"tfoot\" colspan=\"6\">
					<div class=\"float_right\">{\$findmythreads}</div>
					<div>{\$lang->lastxonucp_mytotalthreads}: {\$mytotalthreads}</div>
				</td>
			</tr>
		</thead>
	</table>",
		'sid' => "-1",
		'version' => "",
		'dateline' => TIME_NOW
	);
	
	$db->insert_query("templates", $insert_array);
	
	$insert_array = array(
		'title' => "usercp_mypopthreads",
		'template' => "<br />
	<table border=\"0\" cellspacing=\"{\$theme[\'borderwidth\']}\" cellpadding=\"{\$theme[\'tablespace\']}\" class=\"tborder\">
		<thead>
			<tr>
				<td class=\"thead\" colspan=\"6\">
					<div><strong>{\$lang->lastxonucp_mypopthreads}</strong></div>
				</td>
			</tr>
			<tr>
				<td class=\"tcat\" width=\"5%\">&nbsp;</td>
				<td class=\"tcat\" width=\"40%\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_thread}</strong></span></td>
				<td class=\"tcat\" width=\"20%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_forum}</strong></span></td>
				<td class=\"tcat\" width=\"10%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_replies}</strong></span></td>
				<td class=\"tcat\" width=\"10%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_views}</strong></span></td>
				<td class=\"tcat\" width=\"15%\" align=\"center\"><span class=\"smalltext\"><strong>{\$lang->lastxonucp_lastposter}</strong></span></td>
			</tr>
		</thead>
		<tbody>
		{\$mypopthreads}
		</tbody>
		<thead>
			<tr>
                               <td class=\"tfoot\" colspan=\"6\">
					<div class=\"float_right\">{\$findmythreads}</div>
					<div>{\$lang->lastxonucp_mytotalthreads}: {\$mytotalthreads}</div>
				</td>
			</tr>
		</thead>
	</table>",
		'sid' => "-1",
		'version' => "",
		'dateline' => TIME_NOW
	);
	
	$db->insert_query("templates", $insert_array);
	
	$insert_array = array(
		'title' => "usercp_mylastposts_posts",
		'template' => "<tr>
		<td class=\"trow1\" align=\"center\">{\$icon}</td>
		<td class=\"trow2\"><a href=\"{\$threadlink}\" title=\"{\$mlr[\'threadsubject\']}\">{\$mlrthreadsubject}</a></td>
		<td class=\"trow1\"><a href=\"{\$forumlink}\" title=\"{\$mlr[\'forumname\']}\">{\$mlrforumname}</a></td>
		<td class=\"trow2\" align=\"center\">{\$replies}</td>
		<td class=\"trow1\" align=\"center\">{\$views}</td>
		<td class=\"trow2\">{\$threadstarter}</td>
</tr>",
		'sid' => "-1",
		'version' => "",
		'dateline' => TIME_NOW
	);
	
	$db->insert_query("templates", $insert_array);
	
	$insert_array = array(
		'title' => "usercp_mylastthreads_threads",
		'template' => "<tr>
		<td class=\"trow1\" align=\"center\">{\$icon}</td>
		<td class=\"trow2\"><a href=\"{\$threadlink}\" title=\"{\$mlt[\'threadsubject\']}\">{\$mltthreadsubject}</a></td>
		<td class=\"trow1\"><a href=\"{\$forumlink}\" title=\"{\$mlt[\'forumname\']}\">{\$mltforumname}</a></td>
		<td class=\"trow2\" align=\"center\">{\$replies}</td>
		<td class=\"trow1\" align=\"center\">{\$views}</td>
		<td class=\"trow2\">{\$lastposter}</td>
</tr>",
		'sid' => "-1",
		'version' => "",
		'dateline' => TIME_NOW
	);
	
	$db->insert_query("templates", $insert_array);
	
	$insert_array = array(
		'title' => "usercp_mypopthreads_threads",
		'template' => "<tr>
		<td class=\"trow1\" align=\"center\">{\$icon}</td>
		<td class=\"trow2\"><a href=\"{\$threadlink}\" title=\"{\$mpt[\'threadsubject\']}\">{\$mptthreadsubject}</a></td>
		<td class=\"trow1\"><a href=\"{\$forumlink}\" title=\"{\$mpt[\'forumname\']}\">{\$mptforumname}</a></td>
		<td class=\"trow2\" align=\"center\">{\$replies}</td>
		<td class=\"trow1\" align=\"center\">{\$views}</td>
		<td class=\"trow2\">{\$lastposter}</td>
</tr>",
		'sid' => "-1",
		'version' => "",
		'dateline' => TIME_NOW
	);
	
	$db->insert_query("templates", $insert_array);
	
}

function lastxonucp_deactivate()
{
	global $db, $mybb;
	
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("usercp", '#{\$my_last_threads}(\r?)\n{\$my_last_posts}(\r?)\n{\$my_popular_threads}(\r?)\n#', "", 0);
	
	$db->delete_query("templates", "title = 'usercp_mylastposts'");
	$db->delete_query("templates", "title = 'usercp_mylastthreads'");
	$db->delete_query("templates", "title = 'usercp_mypopthreads'");
	$db->delete_query("templates", "title = 'usercp_mylastposts_posts'");
	$db->delete_query("templates", "title = 'usercp_mylastthreads_threads'");
	$db->delete_query("templates", "title = 'usercp_mypopthreads_threads'");
	
}

function lastxonucp_uninstall()
{
	global $db;
	
	// DELETE ALL SETTINGS TO AVOID DUPLICATES
	$db->write_query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN(
		'lastxonucp_showlastthreads',
		'lastxonucp_threadnum',
		'lastxonucp_showlastposts',
		'lastxonucp_postnum',
		'lastxonucp_showpopular',
		'lastxonucp_popnum',
		'lastxonucp_poporder',
		'lastxonucp_threadcut',
		'lastxonucp_forumcut'
	)");
	$db->delete_query("settinggroups", "name = 'lastxonucp'");
	rebuild_settings();
}

function lastxonucp_run()
{
	global $db, $mybb, $templates, $theme, $lang, $my_last_threads, $my_last_posts, $my_popular_threads;
	
	$lang->load("lastxonucp");
	
	if($mybb->settings['lastxonucp_showlastthreads'] == "1")
	{
		$threadlimit = $mybb->settings['lastxonucp_threadnum'];
		$mltquery = $db->query("
			SELECT t.*, t.subject AS threadsubject, u.username, u.usergroup, u.displaygroup, f.*, i.*, i.name AS iconname,
			t.dateline AS threaddate, f.name AS forumname
			FROM ".TABLE_PREFIX."threads t
			LEFT JOIN ".TABLE_PREFIX."forums f ON (f.fid=t.fid)
			LEFT JOIN ".TABLE_PREFIX."icons i ON (i.iid=t.icon)
			LEFT JOIN ".TABLE_PREFIX."users u ON (t.lastposter=u.username)
			WHERE t.uid = '".$mybb->user['uid']."'
			AND t.visible = '1'
			GROUP BY t.tid
			ORDER BY threaddate DESC
			LIMIT 0, $threadlimit
		");
		
		$myttquery = $db->query("SELECT COUNT(*) AS totalthreads FROM ".TABLE_PREFIX."threads WHERE uid='".$mybb->user['uid']."'");
		$mytt = $db->fetch_array($myttquery);
		$mytotalthreads = $mytt['totalthreads'];
		$findmythreads = "<a href=\"".$mybb->settings['bburl']."/search.php?action=finduserthreads&uid=".$mybb->user['uid']."\">".$lang->lastxonucp_findmythreads."</a>";
		
		while($mlt = $db->fetch_array($mltquery))
		{

			if($mlt['icon'] > 0)
			{
				$icon = "<img src=\"{$mlt['path']}\" alt=\"{$mlt['iconname']}\" title=\"{$mlt['iconname']}\" />";
			}
			else
			{
				$icon = "&nbsp;";
			}
	
			if(strlen($mlt['threadsubject']) > $mybb->settings['lastxonucp_threadcut'])
			{
				$mltthreadsubject = my_substr($mlt['threadsubject'],0,$mybb->settings['lastxonucp_threadcut'])."...";
			}
			else
			{
				$mltthreadsubject = $mlt['threadsubject'];
			}
	
			if(strlen($mlt['forumname']) > $mybb->settings['lastxonucp_forumcut'])
			{
				$mltforumname = my_substr($mlt['forumname'],0,$mybb->settings['lastxonucp_forumcut'])."...";
			}
			else
			{
				$mltforumname = $mlt['forumname'];
			}
	
			$threadlink = get_thread_link($mlt['tid']);
			$forumlink = get_forum_link($mlt['fid']);
			$replies = my_number_format($mlt['replies']);
			$views = my_number_format($mlt['views']);
			$lastposter = format_name($mlt['username'], $mlt['usergroup'], $mlt['displaygroup']);
			$lastposter = build_profile_link($lastposter, $mlt['lastposteruid']);
			$lang->lastxonucp_mylastthreads = $lang->sprintf($lang->lastxonucp_mylastthreads, $mybb->settings['lastxonucp_threadnum']);
	
			eval("\$mylastthreads .= \"".$templates->get("usercp_mylastthreads_threads")."\";");
	
		}
		
		if($mylastthreads)
		{
			eval("\$my_last_threads = \"".$templates->get("usercp_mylastthreads")."\";");
		}
		
	}
	
	if($mybb->settings['lastxonucp_showlastposts'] == "1")
	{
		$postlimit = $mybb->settings['lastxonucp_postnum'];
		$mlrquery = $db->query("
			SELECT t.*, t.subject AS threadsubject, t.username AS threadstarter, t.uid AS threadstarterid, u.username, u.usergroup, u.displaygroup, p.*, f.*, i.*, i.name AS iconname,
			t.dateline AS threaddate, p.dateline AS lastpostdate, f.name AS forumname
			FROM ".TABLE_PREFIX."posts p
			LEFT JOIN ".TABLE_PREFIX."threads t ON (t.tid=p.tid)
			LEFT JOIN ".TABLE_PREFIX."forums f ON (f.fid=t.fid)
			LEFT JOIN ".TABLE_PREFIX."icons i ON (i.iid=t.icon)
			LEFT JOIN ".TABLE_PREFIX."users u ON (u.uid=t.uid)
			WHERE p.uid = '".$mybb->user['uid']."'
			AND t.visible = '1'
			GROUP BY p.pid
			ORDER BY lastpostdate DESC
			LIMIT 0, $postlimit
		");
		
		$mytpquery = $db->query("SELECT COUNT(*) AS totalposts FROM ".TABLE_PREFIX."posts WHERE uid='".$mybb->user['uid']."'");
		$mytp = $db->fetch_array($mytpquery);
		$mytotalposts = $mytp['totalposts'];
		$findmyposts = "<a href=\"".$mybb->settings['bburl']."/search.php?action=finduser&uid=".$mybb->user['uid']."\">".$lang->lastxonucp_findmyposts."</a>";
	
		while($mlr = $db->fetch_array($mlrquery))
		{

			if($mlr['icon'] > 0)
			{
				$icon = "<img src=\"{$mlr['path']}\" alt=\"{$mlr['iconname']}\" title=\"{$mlr['iconname']}\" />";
			}
			else
			{
				$icon = "&nbsp;";
			}
		
			if(strlen($mlr['threadsubject']) > $mybb->settings['lastxonucp_threadcut'])
			{
				$mlrthreadsubject = my_substr($mlr['threadsubject'],0,$mybb->settings['lastxonucp_threadcut'])."...";
			}
			else
			{
				$mlrthreadsubject = $mlr['threadsubject'];
			}
	
			if(strlen($mlr['forumname']) > $mybb->settings['lastxonucp_forumcut'])
			{
				$mlrforumname = my_substr($mlr['forumname'],0,$mybb->settings['lastxonucp_forumcut'])."...";
			}
			else
			{
				$mlrforumname = $mlr['forumname'];
			}
	
			$threadlink = get_thread_link($mlr['tid']);
			$forumlink = get_forum_link($mlr['fid']);
			$replies = my_number_format($mlr['replies']);
			$views = my_number_format($mlr['views']);
			$threadstarter = format_name($mlr['threadstarter'], $mlr['usergroup'], $mlr['displaygroup']);
			$threadstarter = build_profile_link($threadstarter, $mlr['threadstarterid']);
			$lang->lastxonucp_mylastposts = $lang->sprintf($lang->lastxonucp_mylastposts, $mybb->settings['lastxonucp_postnum']);
	
			eval("\$mylastposts .= \"".$templates->get("usercp_mylastposts_posts")."\";");
		}
		
		if($mylastposts)
		{
			eval("\$my_last_posts = \"".$templates->get("usercp_mylastposts")."\";");
		}
		
	}
	
	if($mybb->settings['lastxonucp_showpopular'] == "1")
	{
		$threadlimit = $mybb->settings['lastxonucp_popnum'];
		
		switch($mybb->settings['lastxonucp_poporder'])
		{
			case 0:	$order = 'views'; break;
			case 1:	$order = 'replies'; break;
  		}
		
		$mptquery = $db->query("
			SELECT t.*, t.subject AS threadsubject, u.username, u.usergroup, u.displaygroup, f.*, i.*, i.name AS iconname,
			t.dateline AS threaddate, f.name AS forumname
			FROM ".TABLE_PREFIX."threads t
			LEFT JOIN ".TABLE_PREFIX."forums f ON (f.fid=t.fid)
			LEFT JOIN ".TABLE_PREFIX."icons i ON (i.iid=t.icon)
			LEFT JOIN ".TABLE_PREFIX."users u ON (t.lastposter=u.username)
			WHERE t.uid = '".$mybb->user['uid']."'
			AND t.visible = '1'
			GROUP BY t.tid
			ORDER BY $order DESC
			LIMIT 0, $threadlimit
		");
		
		$myptquery = $db->query("SELECT COUNT(*) AS totalthreads FROM ".TABLE_PREFIX."threads WHERE uid='".$mybb->user['uid']."'");
		$mypt = $db->fetch_array($myptquery);
		$mytotalthreads = $mypt['totalthreads'];
		$findmythreads = "<a href=\"".$mybb->settings['bburl']."/search.php?action=finduserthreads&uid=".$mybb->user['uid']."\">".$lang->lastxonucp_findmythreads."</a>";
		
		while($mpt = $db->fetch_array($mptquery))
		{

			if($mpt['icon'] > 0)
			{
				$icon = "<img src=\"{$mpt['path']}\" alt=\"{$mpt['iconname']}\" title=\"{$mpt['iconname']}\" />";
			}
			else
			{
				$icon = "&nbsp;";
			}
	
			if(strlen($mpt['threadsubject']) > $mybb->settings['lastxonucp_threadcut'])
			{
				$mptthreadsubject = my_substr($mpt['threadsubject'],0,$mybb->settings['lastxonucp_threadcut'])."...";
			}
			else
			{
				$mptthreadsubject = $mpt['threadsubject'];
			}
	
			if(strlen($mpt['forumname']) > $mybb->settings['lastxonucp_forumcut'])
			{
				$mptforumname = my_substr($mpt['forumname'],0,$mybb->settings['lastxonucp_forumcut'])."...";
			}
			else
			{
				$mptforumname = $mpt['forumname'];
			}
	
			$threadlink = get_thread_link($mpt['tid']);
			$forumlink = get_forum_link($mpt['fid']);
			$replies = my_number_format($mpt['replies']);
			$views = my_number_format($mpt['views']);
			$lastposter = format_name($mpt['username'], $mpt['usergroup'], $mpt['displaygroup']);
			$lastposter = build_profile_link($lastposter, $mpt['lastposteruid']);
			$lang->lastxonucp_mypopthreads = $lang->sprintf($lang->lastxonucp_mypopthreads, $mybb->settings['lastxonucp_threadnum']);
	
			eval("\$mypopthreads .= \"".$templates->get("usercp_mypopthreads_threads")."\";");
	
		}
		
		if($mypopthreads)
		{
			eval("\$my_popular_threads = \"".$templates->get("usercp_mypopthreads")."\";");
		}
		
	}

}

?>